/* 2PT / Dunk Animation — League-only, CFB_<CONF> naming, PNG sequence, per-team render */

// Put this at the very top of batch_ScoringAnimations4-2PT.jsx

function __read_env_json(){
  try{
    var p = $.getenv("AE_BRIDGE_JSON"); if (!p) return {};
    var f = File(p); if (!f.exists) return {};
    f.open("r"); var txt = f.read(); f.close();
    return eval("("+txt+")"); // JSON.parse may not exist in ExtendScript
  }catch(e){ return {}; }
}
var __BRIDGE_ENV = __read_env_json();

function env(k, d){
  var v = $.getenv(k);
  if (v===null || v===undefined || v==="") {
    v = (__BRIDGE_ENV && __BRIDGE_ENV[k] !== undefined) ? __BRIDGE_ENV[k] : d;
  }
  return v;
}

// one-line confirmation in AE Console
$.writeln("[CFG 2PT] COMP="+env("AE_COMP","<nil>")
  +"  LEAGUE="+env("AE_LEAGUE","<nil>")
  +"  OUTDIR="+env("AE_OUTDIR","<nil>")
  +"  OM="+env("AE_OM_TEMPLATE","<nil>"));


(function () {
  // ---------- tiny utils ----------
  function env(k,d){ var v=$.getenv(k); return (v===null||v===undefined||v==="")?d:v; }
  function fail(msg){ alert(msg); throw new Error(msg); }
  function trim(s){ var t=String(s||""); while(/^[ \t\r\n]/.test(t)) t=t.substring(1); while(/[ \t\r\n]$/.test(t)) t=t.substring(0,t.length-1); return t; }
  function toLower(s){ return String(s||"").toLowerCase(); }
  function clamp01(v){ return Math.max(0, Math.min(1, v)); }
  function sanitize(s){ var bad='\\/:*?"<>|', t=String(s||""), out="", i, ch; for(i=0;i<t.length;i++){ ch=t.charAt(i); out+=(bad.indexOf(ch)>=0?"-":ch);} return out; }
  function hasExt(p){ return /\.[A-Za-z0-9]+$/.test(p); }
  function numOr(v,def){ var n=parseFloat(v); return (isFinite(n) ? n : def); }
  function safeColor(c){ if (!c || c.length!==3) return [0,0,0]; function cl(x){ return (x<0?0:(x>1?1:x)); } return [cl(numOr(c[0],0)),cl(numOr(c[1],0)),cl(numOr(c[2],0))]; }
  function cleanValue(v){
    if (!v && v!==0) return "";
    var s = String(v);
    s = s.replace(/^["']+|["']+$/g, '');
    s = s.replace(/[\u00A0\u1680\u180E\u2000-\u200B\u202F\u205F\u3000]/g, ' ');
    s = s.replace(/\s+/g, ' ');
    s = s.replace(/^[ \t\r\n]+|[ \t\r\n]+$/g, '');
    return s;
  }

  // ---------- league normalization ----------
  function normalizeLeagueBase(s){
    var U = cleanValue(s).toUpperCase();
    if (U.indexOf("_") !== -1) U = U.split("_")[0];
    var uNoSep = U.replace(/[\s\-]/g, "");
    if (uNoSep==="NCAAF" || uNoSep==="NCAAFOOTBALL" || uNoSep==="COLLEGEFOOTBALL" || uNoSep==="CFB") return "CFB";
    return U; // NFL, NHL, etc.
  }

  // ---------- smart colors ----------
  function isBlackOrNearlyBlack(c){ if (!c || c.length!==3) return true; return (c[0]<=0.05 && c[1]<=0.05 && c[2]<=0.05); }
  function getSmartPrimary(primary, secondary){ return isBlackOrNearlyBlack(primary) ? secondary : primary; }
  function getSmartSecondary(primary, secondary){
    var p=getSmartPrimary(primary,secondary);
    if (p[0]===secondary[0]&&p[1]===secondary[1]&&p[2]===secondary[2]) return [secondary[0]*0.7,secondary[1]*0.7,secondary[2]*0.7];
    return secondary;
  }
  function getAccentColor(primary, secondary){
    var p=getSmartPrimary(primary,secondary);
    return [p[0]*0.5,p[1]*0.5,p[2]*0.5];
  }
  function rgb01(r,g,b){ return [clamp01(numOr(r,0)/255), clamp01(numOr(g,0)/255), clamp01(numOr(b,0)/255)]; }
  function trySet(p,v){ if (!p) return false; try{ p.setValue(v); return true; }catch(e){ return false; } }

  // ---------- env (LEAGUE ONLY) ----------
  var PROJECT   = env("AE_PROJECT", null);
  var CSV_PATH  = env("AE_CSV", null);
  var COMP_NAME = env("AE_COMP","2PT");

  var TEAMNAME_LAYER  = env("AE_TEAMNAME_LAYER","TeamName");
  var SOLID_LAYER     = env("AE_SOLID_LAYER","Solid");
  var DUNK_PRECOMP    = env("AE_DUNK_PRECOMP","Dunk");
  var TWOPOINT_LAYER  = env("AE_2PT_LAYER","2 POINT PLAY");
  var LOGO_LAYER      = env("AE_LOGO_LAYER","TeamLogo");

  var LOGO_DIR   = env("AE_LOGO_DIR","");
  var LOGO_TPL   = env("AE_LOGO_PATH_TEMPLATE","{league}/{abbr}");
  var LOGO_EXTS  = env("AE_LOGO_EXTS","png,jpg,jpeg,svg,ai,psd").split(",");

  var LEAGUE    = env("AE_LEAGUE",""); // REQUIRED
  var LIMIT_STR = env("AE_LIMIT","");
  var LIMIT     = (LIMIT_STR && !isNaN(parseInt(LIMIT_STR,10))) ? parseInt(LIMIT_STR,10) : null;

  var OUTDIR    = env("AE_OUTDIR","");
  var PATH_TPL  = env("AE_PATH_TEMPLATE","{league}");
  var ANIM_NAME = env("AE_ANIM","2PT");
  var RS_TPL    = env("AE_RS_TEMPLATE","Best Settings");
  var OM_TPL    = env("AE_OM_TEMPLATE","PNG Sequence"); // PNG sequence
  var PURGE     = (env("AE_PURGE_BEFORE_RENDER","1")==="1");
  var NO_RENDER = (env("AE_NO_RENDER","0")==="1");
  var QUIT_APP  = (env("AE_QUIT","1")==="1");

  // ---------- logos ----------
  function findLogoFile(league, abbr){
    if (!LOGO_DIR) return null;
    var tpl = LOGO_TPL.replace("{league}",league||"").replace("{abbr}",abbr||"")
                      .replace("{league_lc}", String(league||"").toLowerCase())
                      .replace("{abbr_lc}",   String(abbr||"").toLowerCase())
                      .replace("{league_uc}", String(league||"").toUpperCase())
                      .replace("{abbr_uc}",   String(abbr||"").toUpperCase());
    if (hasExt(tpl)){ var f1 = new File(LOGO_DIR + "/" + tpl); if (f1.exists) return f1; }
    for (var i=0;i<LOGO_EXTS.length;i++){ var f2 = new File(LOGO_DIR + "/" + tpl + "." + trim(LOGO_EXTS[i])); if (f2.exists) return f2; }
    return null;
  }
  function replaceLogo(comp, layerName, league, abbr){
    var lyr = comp.layer(layerName); if (!lyr || !LOGO_DIR) return;
    var f = findLogoFile(league, abbr); if (!f) return;
    var io = new ImportOptions(f); if (!io.canImportAs(ImportAsType.FOOTAGE)) return;
    var footage = app.project.importFile(io);
    lyr.replaceSource(footage, false);
  }

  // ---------- CSV ----------
  function openRead(path){ var f=new File(path); if(!f.exists) fail("File not found: "+path); f.open("r"); var s=f.read(); f.close(); return s; }
  function parseCSV(txt){
    var raw=txt.split(/\r\n|\n|\r/), lines=[], i; for(i=0;i<raw.length;i++){ var L=raw[i]; if(L && !/^\s*$/.test(L)) lines.push(L); }
    var rows=[], c; for(i=0;i<lines.length;i++){ var line=lines[i]; var cells=(line.indexOf("\t")!==-1? line.split("\t") : line.split(",")); 
      for(c=0;c<cells.length;c++){ var cell=trim(cells[c]); if(cell.charAt(0)=='"' && cell.charAt(cell.length-1)=='"') cell=cell.substring(1,cell.length-1); cells[c]=cell; }
      rows.push(cells);
    }
    if(rows.length<2) fail("CSV has no data."); return rows;
  }
  function headerIdx(h){
    var m={}, i; for(i=0;i<h.length;i++) m[toLower(h[i])]=i;
    function need(x){ if(m[x]===undefined) fail("Missing column: "+x); }
    need("abbreviation"); need("r"); need("g"); need("b"); need("r2"); need("g2"); need("b2");
    return m;
  }
  function optIdx(idx, names){ for (var i=0;i<names.length;i++){ var k=names[i]; if (idx[k]!==undefined) return idx[k]; } return undefined; }
  function buildTeams(rows){
    var h=rows[0], idx=headerIdx(h), out=[], i;
    var leagueIdx = optIdx(idx,["league"]);
    var nameIdx   = optIdx(idx,["displayname","name"]);
    var confIdx   = optIdx(idx,["conference","conf","group"]);
    for(i=1;i<rows.length;i++){
      var r=rows[i]; var ab=cleanValue(r[idx["abbreviation"]]); if(!ab) continue;
      out.push({
        abbr: ab,
        league: leagueIdx!==undefined ? cleanValue(r[leagueIdx]) : cleanValue(LEAGUE||"NA"),
        conference: (confIdx!==undefined ? cleanValue(r[confIdx]) : ""),
        name: (nameIdx!==undefined ? cleanValue(r[nameIdx]) : ab),
        primary:   rgb01(r[idx["r"]],  r[idx["g"]],  r[idx["b"]]),
        secondary: rgb01(r[idx["r2"]], r[idx["g2"]], r[idx["b2"]])
      });
    }
    return out;
  }

  // ---------- filtering ----------
  function pickTeamsLeagueOnly(all){
    var res=[], i;
    var targetBase = normalizeLeagueBase(LEAGUE);
    if (!targetBase) fail("AE_LEAGUE is required.");
    for (i=0;i<all.length;i++){
      var teamBase = normalizeLeagueBase(all[i].league);
      if (teamBase === targetBase) res.push(all[i]);
    }
    if (LIMIT && res.length>LIMIT) res=res.slice(0,LIMIT);
    return res;
  }

  // ---------- AE helpers ----------
  function findComp(name){ for(var i=1;i<=app.project.numItems;i++){ var it=app.project.item(i); if(it instanceof CompItem && it.name===name) return it; } return null; }
  function getLayer(comp,name){ try{ return comp.layer(name); }catch(e){ return null; } }
  function setTextFillColor(layer, color){
    var st=layer.property("Source Text"); if(!st) return false;
    var td=st.value; td.applyFill=true; td.fillColor=safeColor(color); td.applyStroke=false;
    try{ st.setValue(td); return true; }catch(e){ return false; }
  }
  function setTextContent(layer, text){
    var st=layer.property("Source Text"); if(!st) return false;
    var td=st.value; td.text=String(text||"");
    try{ st.setValue(td); return true; }catch(e){ return false; }
  }
  function setSolidColor(layer, color){
    try{
      var src=layer.source;
      if (src && src.mainSource && src.mainSource.color!==undefined){ src.mainSource.color=safeColor(color); return true; }
    }catch(e){}
    var fx=layer.property("Effects");
    if (fx){
      var fill=null;
      for (var i=1;i<=fx.numProperties;i++){ if (fx.property(i).matchName==="ADBE Fill"){ fill=fx.property(i); break; } }
      if (!fill) fill = fx.addProperty("ADBE Fill");
      if (fill) return trySet(fill.property("Color"), safeColor(color));
    }
    return false;
  }
  function setTintEffectColors(layer, color){
    var fx=layer.property("Effects"); if(!fx) return false;
    var tint=null;
    for (var i=1;i<=fx.numProperties;i++){ var e=fx.property(i); if (e.matchName==="ADBE Tint"){ tint=e; break; } }
    if (!tint) return false;
    var ok=false;
    var mb=tint.property("Map Black To"); if (mb && trySet(mb, safeColor(color))) ok=true;
    var mw=tint.property("Map White To"); if (mw && trySet(mw, safeColor(color))) ok=true;
    return ok;
  }
  function processDunkLayers(comp, smartPrimary, smartSecondary, depth){
    if (!depth) depth=0; if (depth>5) return 0;
    var processed=0;
    for (var i=1;i<=comp.numLayers;i++){
      var layer=comp.layer(i);
      var nm=layer.name, up=nm.toUpperCase();

      if (layer.source && (layer.source instanceof CompItem)){
        processed += processDunkLayers(layer.source, smartPrimary, smartSecondary, depth+1);
      }
      if (up==="DUNK-PRIMARY" || up==="PRIMARY" || nm==="Dunk-Primary" || nm==="Primary"){
        if (setTintEffectColors(layer, smartPrimary)) processed++;
      } else if (up==="DUNK-SECONDARY" || up==="SECONDARY" || nm==="Dunk-Secondary" || nm==="Secondary"){
        if (setTintEffectColors(layer, smartSecondary)) processed++;
      }
    }
    return processed;
  }

  // ---------- path helpers ----------
  function animNameSafe(s){ var v=cleanValue(s); return v.replace(/^[\s_\-]+/,""); }
  function leagueAndConfForPath(teamLeague, teamConf){
    var raw=cleanValue(teamLeague||"");
    var U=raw.toUpperCase();
    var base=normalizeLeagueBase(U), conf="";
    if (U.indexOf("_")!==-1){ var parts=U.split("_"); conf=parts.slice(1).join("_"); }
    if (!conf && teamConf) conf=cleanValue(teamConf).toUpperCase();
    return { base: base||"NA", conf: conf };
  }

  // ---------- run ----------
  if (app.beginSuppressDialogs){ try{ app.beginSuppressDialogs(); }catch(e){} }
  app.beginUndoGroup("2PT - League Only - PNG Seq");

  if(!PROJECT) fail("AE_PROJECT env not set.");
  var aep=new File(PROJECT); if(!aep.exists) fail("AE_PROJECT not found: "+PROJECT);
  app.open(aep);

  if(!CSV_PATH) fail("AE_CSV env not set.");
  if(!LEAGUE || cleanValue(LEAGUE)==="") fail("AE_LEAGUE is required.");

  var rows=parseCSV(openRead(CSV_PATH));
  var teams=buildTeams(rows);
  var todo=pickTeamsLeagueOnly(teams);
  if(!todo.length) fail("No teams matched league: "+LEAGUE);

  var comp=findComp(COMP_NAME); if(!comp) fail("Comp not found: "+COMP_NAME);

  var rootOut = OUTDIR ? new Folder(OUTDIR) : (app.project.file ? app.project.file.parent : Folder.desktop);
  if(!rootOut.exists) rootOut.create();

  while(app.project.renderQueue.numItems>0){ app.project.renderQueue.item(1).remove(); }

  var ANIM_SAFE = animNameSafe(ANIM_NAME);

  for (var i=0;i<todo.length;i++){
    var t = todo[i];
    var primary   = safeColor(t.primary);
    var secondary = safeColor(t.secondary);
    var smartP = getSmartPrimary(primary, secondary);
    var smartS = getSmartSecondary(primary, secondary);
    var accent = getAccentColor(primary, secondary);

    // Apply colors/text
    var solidLy = getLayer(comp, SOLID_LAYER); if (solidLy) setSolidColor(solidLy, smartP);
    var nameLy  = getLayer(comp, TEAMNAME_LAYER); if (nameLy){ setTextFillColor(nameLy, smartS); setTextContent(nameLy, t.name); }
    var twoLy   = getLayer(comp, TWOPOINT_LAYER); if (twoLy) setTextFillColor(twoLy, accent);

    var dunkLy  = getLayer(comp, DUNK_PRECOMP);
    if (dunkLy && dunkLy.source && (dunkLy.source instanceof CompItem)){ processDunkLayers(dunkLy.source, smartP, smartS, 0); }

    replaceLogo(comp, LOGO_LAYER, t.league, t.abbr);

    if (PURGE && app.purge) { try{ app.purge(PurgeTarget.ALL_CACHES); }catch(e){} }

    if (!NO_RENDER){
      var lc = leagueAndConfForPath(t.league, t.conference);
      var leagueBase = lc.base;
      var confLabel  = lc.conf;

      var sub = PATH_TPL.replace("{league}", sanitize(leagueBase)).replace("{abbr}", sanitize(t.abbr));
      var outL1 = new Folder(rootOut.fsName + "/" + sub); if (!outL1.exists) outL1.create();

      var folderName = confLabel
        ? (sanitize(leagueBase)+"_"+sanitize(confLabel)+"_"+sanitize(t.abbr)+"_"+ANIM_SAFE)
        : (sanitize(leagueBase)+"_"+sanitize(leagueBase)+"_"+sanitize(t.abbr)+"_"+ANIM_SAFE);
      var animFolder = new Folder(outL1.fsName + "/" + folderName); if (!animFolder.exists) animFolder.create();

      var outFile = File(animFolder.fsName + "/0000"); // OM adds numbering (0000.png, ...)

      while(app.project.renderQueue.numItems>0){ app.project.renderQueue.item(1).remove(); }
      var rq = app.project.renderQueue.items.add(comp);
      try{ rq.applyTemplate(RS_TPL); }catch(e){}
      var om = rq.outputModule(1);
      try{ om.applyTemplate(OM_TPL); }catch(e){}
      om.file = outFile;

      app.project.renderQueue.render(); // render now with current colors
      while(app.project.renderQueue.numItems>0){ app.project.renderQueue.item(1).remove(); }
    }
  }

  app.endUndoGroup();
  if (app.endSuppressDialogs){ try{ app.endSuppressDialogs(); }catch(e){} }
  if (QUIT_APP) app.quit();
})();
